/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.console;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.ui.console.IHyperlink;
import org2.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org2.eclipse.php.internal.debug.core.launching.DebugConsoleMonitor;
import org2.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org2.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org2.eclipse.php.internal.debug.ui.console.PHPFileLink;

public class PHPConsoleListener
implements IPHPConsoleEventListener {
    protected ILaunch fLaunch;
    protected DebugConsoleMonitor fConsoleMonitor;
    protected PHPHyperLink fPHPHyperLink;

    @Override
    public void init(ILaunch launch, DebugConsoleMonitor consoleMonitor, PHPHyperLink link) {
        this.fLaunch = launch;
        this.fConsoleMonitor = consoleMonitor;
        this.fPHPHyperLink = link;
    }

    @Override
    public void handleEvent(DebugError debugError) {
        IHyperlink link = this.createLink(debugError);
        String message = debugError.toString().trim();
        this.fPHPHyperLink.addLink(link, message, message.length() - debugError.getErrorTextLength());
        this.fConsoleMonitor.append(String.valueOf(debugError.toString()) + '\n');
    }

    protected IHyperlink createLink(DebugError debugError) {
        String fileName = debugError.getFullPathName();
        int lineNumber = debugError.getLineNumber();
        return new PHPFileLink(fileName, -1, -1, lineNumber);
    }
}

